<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PackageResource\Pages;
use App\Filament\Resources\PackageResource\RelationManagers;
use App\Models\Package;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PackageResource extends Resource
{
    protected static ?string $model = Package::class;

    protected static ?string $navigationGroup = 'Manage';
    protected static ?string $navigationIcon = 'heroicon-o-globe-alt';
    protected static ?string $navigationLabel = 'Packages';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([

                Forms\Components\TextInput::make('title')
                    ->label('Title')
                    ->placeholder('e.g Vacation to the water city of Portugala')
                    ->required()
                    ->maxLength(255)
                    ->columnSpanFull(),

                Forms\Components\Textarea::make('brief')
                    ->label('Description')
                    ->placeholder('Enter Brief details about this Tour')
                    ->rows(8)
                    ->required()
                    ->columnSpanFull(),

                Forms\Components\TextInput::make('pax')
                    ->label('Group Size')
                    ->placeholder('No. of PAX')
                    ->required()
                    ->maxLength(255)
                    ->columnSpanFull(),

                Forms\Components\TextInput::make('days')
                    ->label('Trip Duration (Days)')
                    ->placeholder('Days')
                    ->required()
                    ->maxLength(255),

                Forms\Components\TextInput::make('nights')
                    ->label('Nights')
                    ->placeholder('Nights')
                    ->required()
                    ->maxLength(255),


                // PAckage Cost
                Forms\Components\TextInput::make('reg_amount')
                    ->label('Package Regular Cost (in USD)')
                    ->placeholder('e.g 2000')
                    ->required()
                    ->maxLength(255),

                Forms\Components\TextInput::make('sale_amount')
                    ->label('Package Sale Price (in USD)')
                    ->placeholder('any discounted price')
                    ->maxLength(255),


                // Location
                Forms\Components\TextInput::make('location')
                    ->label('Location/Country')
                    ->placeholder('e.g USA, UK etc')
                    ->required()
                    ->maxLength(255),

                Forms\Components\FileUpload::make('gallery')
                    ->label('Tour Photos Gallery')
                    ->directory('packages')
                    ->image()
                    ->multiple()
                    ->required()
                    ->columnSpanFull(),

                Forms\Components\FileUpload::make('itinerary')
                    ->label('Upload Package Itinerary PDF')
                    ->directory('pdf')
                    ->acceptedFileTypes(['application/pdf'])
                    ->required()
                    ->columnSpanFull(),

                Forms\Components\Select::make('status')
                    ->label('Is Active?')
                    ->options([
                        0 => 'No',
                        1 => 'Active',
                    ])
                    ->required()
                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->searchable(),
                Tables\Columns\TextColumn::make('location')
                    ->label('Destination')
                    ->searchable(),
                Tables\Columns\IconColumn::make('status')
                    ->boolean()
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Added On')
                    ->dateTime('d M Y')
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->emptyStateActions([
                Tables\Actions\CreateAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPackages::route('/'),
            'create' => Pages\CreatePackage::route('/create'),
            'edit' => Pages\EditPackage::route('/{record}/edit'),
        ];
    }
}
