<?php

namespace App\Filament\Resources\PackageResource\Pages;

use App\Filament\Resources\PackageResource;
use App\Models\Package;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Support\Facades\Storage;

class EditPackage extends EditRecord
{
    protected static string $resource = PackageResource::class;


    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
            ->after(function (Package $record) {
                // delete single
                if ($record->thumbnail) {
                    Storage::disk('public')->delete($record->photo);
                }

                if($record->brief_file) {
                    Storage::disk('public')->delete($record->brief_file);
                }

                // delete multiple
                if ($record->galery) {
                    foreach ($record->galery as $ph) Storage::disk('public')->delete($ph);
                }
            }),
        ];
    }

}
