<?php

namespace App\Http\Controllers;

use App\Models\Gallery;
use App\Models\Inquiry;
use App\Models\Package;
use Illuminate\Http\Request;

class WebController extends Controller
{
    public function home()
    {
        return view('pages.home');
    }

    public function about()
    {
        return view('pages.about');
    }

    public function gallery()
    {
        $gallery = Gallery::where('status',1)->get();
        return view('pages.gallery',compact('gallery'));
    }

    public function contact(Request $request)
    {
        if($request->isMethod('POST'))
        {
            $contact = new Inquiry;
            $contact->name  = $request->name;
            $contact->phone = $request->phone;
            $contact->email = $request->email;
            $contact->message = $request->message;
            $contact->save();

            return back()->with('success','Thankyou for Contacting us!');
        }
        return view('pages.contact');
    }

    public function packages()
    {
        return view('pages.packages');
    }

    public function details($id)
    {
        $package = Package::find($id);
        return view('pages.details',compact('package'));
    }

    public function status()
    {
        return view('pages.status');
    }

    public function nairobiPack()
    {
        return view('pages.nairobi');
    }

}
