<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',
        'brief',
        'pax',
        'days',
        'nights',
        'sale_amount',
        'reg_amount',
        'location',
        'gallery',
        'itinerary',
        'status'
    ];

    protected $casts = [
        'gallery' => 'array',
    ];
}
