<?php

namespace App\View\Components;

use App\Models\Package;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Packages extends Component
{
    public $packages;
    public $paginate;
    /**
     * Create a new component instance.
     */
    public function __construct($paginate = false)
    {
        $this->paginate  = $paginate;
        $this->packages  = ($paginate)
                            ? Package::where('status',1)->paginate(9)
                            : Package::where('status',1)->take(6)->latest()->get();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.packages');
    }
}
