<div class="row">
    @foreach ($packages as $pack)
    <div class="col-lg-4 col-md-6">
        <div class="package-wrap">
            <figure class="feature-image" style="width:364px !important; height:304px !important">
                <a href="{{ route('details',$pack->id) }}">
                    <img src="{{ url('storage/'.$pack->gallery[0]) }}" alt="">
                </a>
            </figure>
            <div class="package-price">
                <h6>
                <span>${{ $pack->reg_amount }} </span> / per person
                </h6>
            </div>
            <div class="package-content-wrap">
                <div class="package-meta text-center">
                <ul>
                    <li>
                        <i class="far fa-clock"></i>
                        {{ $pack->days }}D/{{ $pack->nights }}N
                    </li>
                    <li>
                        <i class="fas fa-user-friends"></i>
                        People: {{ $pack->pax }}
                    </li>
                    <li>
                        <i class="fas fa-map-marker-alt"></i>
                        {{ $pack->location }}
                    </li>
                </ul>
                </div>
                <div class="package-content">
                <h3>
                    <a href="{{ route('details',$pack->id) }}">{{ $pack->title }}</a>
                </h3>
                <div class="review-area">
                    <span class="review-text">({{ rand(25,100) }} reviews)</span>
                    <div class="rating-start" title="Rated 5 out of 5">
                        <span style="width: {{ rand(50,100) }}%"></span>
                    </div>
                </div>
                <p>{{ Str::limit($pack->brief,100) }}</p>
                <div class="btn-wrap">
                    <a href="{{ route('details',$pack->id) }}" class="button-text">Book Now<i class="fas fa-arrow-right"></i></a>
                </div>
                </div>
            </div>
        </div>
    </div>
    @endforeach

    @if($paginate)
        <div class="col-md-12">
            {{ $packages->links() }}
        </div>
    @endif
</div>
