@extends('layouts.web')
@section('content')
<x-crumb title="Package Detail" />

<!-- Inner Banner html end-->
<div class="single-tour-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="single-tour-inner">

                    <div class="single-tour-gallery">
                        <div class="single-tour-slider">
                            @foreach ($package->gallery as $item)
                            <div class="single-tour-item">
                                <figure class="feature-image">
                                    <img src="{{ asset('storage/'.$item) }}" alt="">
                                </figure>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <h2>{{ $package->title }}</h2>
                    <figure class="feature-image">

                        <div class="package-meta text-center">
                            <ul>
                                <li>
                                    <i class="far fa-clock"></i>
                                    {{ $package->days }} days / {{ $package->nights }} night
                                </li>
                                <li>
                                    <i class="fas fa-user-friends"></i>
                                    People: {{ $package->pax }}
                                </li>
                                <li>
                                    <i class="fas fa-map-marked-alt"></i>
                                    {{ $package->location }}
                                </li>
                            </ul>
                        </div>
                    </figure>
                    <div class="tab-container">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="overview-tab" data-toggle="tab" href="#overview"
                                    role="tab" aria-controls="overview" aria-selected="true">DESCRIPTION</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="program-tab" data-toggle="tab" href="#program" role="tab"
                                    aria-controls="program" aria-selected="false">ITINERARY</a>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="overview" role="tabpanel"
                                aria-labelledby="overview-tab">
                                <div class="overview-content">
                                    {{ $package->brief }}
                                </div>
                            </div>
                            <div class="tab-pane" id="program" role="tabpanel" aria-labelledby="program-tab">
                                <div class="itinerary-content">

                                    <div class="row">
                                        <div class="col-md-6">
                                            <h3>ITINERARY</h3>
                                        </div>
                                        <div class="col-md-6">
                                            <a href="{{ asset('storage/'.$package->itinerary) }}"
                                                class="btn btn-primary btn-block" download='{{ Str::kebab($package->title) }}-itinerary'>
                                                <i class="fa fa-download"></i>
                                                DOWNLOAD ITINERARY
                                            </a>
                                        </div>
                                    </div>
                                    <hr>
                                    <p>
                                        <iframe src="{{ asset('storage/'.$package->itinerary) }}#toolbar=1&navpanes=0&scrollbar=0"
                                                width="800"
                                                height="800">
                                        </iframe>
                                    </p>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>

            <div class="col-lg-4">
                <div class="sidebar">
                    <div class="package-price">
                        <h5 class="price">
                            <span>${{ $package->reg_amount }}</span> / per person
                        </h5>
                        <div class="start-wrap">
                            <div class="rating-start" title="Rated {{ rand(1,5) }} out of 5">
                                <span style="width: 60%"></span>
                            </div>
                        </div>
                    </div>

                    <div class="widget-bg booking-form-wrap">
                        <h4 class="bg-title">Quick Booking</h4>
                        <form action="https://sandbox.flocash.com/ecom/ecommerce.do" method="POST" class="booking-form">

                            <!--Merchant account-->
                            <input type="hidden" name="merchant_name" value="GIPCA" />
                            <input type="hidden" name="merchant" value="gipca@mobirr.com" />

                            <!--Order Id-->
                            <input type="hidden" name="order_id" value="<?php echo rand(100000, 999999); ?>" />
                            <input type="hidden" name="custom" value="<?php echo rand(100000, 999999);?>"/>

                            <!--Currency Code-->
                            <input type="hidden" name="currency_code" readonly="true" value="USD" />
                            <input type="hidden" name="item_name" readonly="true" value="{{ ucwords($package->title) }}" />
                            <input type="hidden" name="item_id" value="{{ $package->id }}" readonly="true">
                            <input type="hidden" name="item_price" readonly="true" value="{{ $package->reg_amount }}.00" />
                            <input type="hidden" name="quantity" readonly="true" value="1" />
                            <input type="hidden" name="amount" value="{{ preg_replace("/[^0-9]/", '', $package->reg_amount) }}" readonly="true">
                            <input type="hidden" name="cancel_url" value="{{ URL::current() }}" readonly="true">

                            <input type="hidden" name="flo_user_planID" value="{{ $package->id }}" readonly="true" required>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input name="flo_user_fullname"  type="text" placeholder="Full Name" required>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input name="flo_user_email" type="text" placeholder="Email" required>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input name="flo_user_number" type="text" placeholder="Number" required>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input class="input-date-picker" type="text" name="flo_user_date" autocomplete="off"
                                            readonly="readonly" placeholder="Date" required>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group submit-btn btn-full">
                                        <input type="submit" name="submit" value="Boook Now">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
