@extends('layouts.web')
@section('content')
<x-crumb title="Gallery" />
<!-- gallery section html start -->
<div class="gallery-section">
    <div class="container">
        <div class="gallery-outer-wrap">
            <div class="gallery-inner-wrap gallery-container grid">
                @foreach ($gallery as $image)
                <div class="single-gallery grid-item">
                    <figure class="gallery-img">
                        <img src="{{ url('storage/'.$image->image) }}" alt="">
                        <div class="gallery-title">
                            <h3>
                                <a href="{{ url('storage/'.$image->image) }}" data-lightbox="lightbox-set">
                                    {{ ucwords($image->title )}}
                                </a>
                            </h3>
                        </div>
                    </figure>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
<!-- gallery section html end -->
@endsection
