@extends('layouts.web')
@section('content')
<x-crumb title="Nairobi National Park Game Drives" />
<!-- Inner Banner html end-->
<div class="single-tour-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="single-tour-inner">

                    <h2>Nairobi National Park Game Drives</h2>


                    <div class="single-tour-gallery">
                        <div class="single-tour-slider">

                            <div class="single-tour-item">
                                <figure class="feature-image">
                                    <img src="{{ asset('assets/images/nairobi/1.jpg') }}" alt="">
                                </figure>
                            </div>

                            <div class="single-tour-item">
                                <figure class="feature-image">
                                    <img src="{{ asset('assets/images/nairobi/2.jpg') }}" alt="">
                                </figure>
                            </div>

                            <div class="single-tour-item">
                                <figure class="feature-image">
                                    <img src="{{ asset('assets/images/nairobi/3.jpg') }}" alt="">
                                </figure>
                            </div>

                            <div class="single-tour-item">
                                <figure class="feature-image">
                                    <img src="{{ asset('assets/images/nairobi/4.jpg') }}" alt="">
                                </figure>
                            </div>

                        </div>
                    </div>

                    <div class="tab-container">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="overview-tab" data-toggle="tab" href="#overview"
                                    role="tab" aria-controls="overview" aria-selected="true">DESCRIPTION</a>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="overview" role="tabpanel"
                                aria-labelledby="overview-tab">
                                <div class="overview-content">
                                    Visit the Nairobi National Park and see monkeys, lions, leopards, buffalos and more on this 4-hour early morning safari drive, with roundtrip transportation to the park included.
                                    <br><br>
                                    <b>Highlights</b><br>
                                    <ul>
                                        <li>Visit the Nairobi National Park with an experienced guide or driver</li>
                                        <li>Stand in the open-roofed vehicle for the best views of the animals</li>
                                        <li>Meet the big cats in their natural habitat</li>
                                        <li>Upgrade to the private open-sided jeep option to go deeper into the bush</li>
                                        <li>Enjoy free Wi-Fi connection and stream live photos and videos from the park</li>
                                    </ul>

                                    <b>Full description</b><br>
                                    Your 40-minute trip to Nairobi National Park will be in an open-roofed van, allowing you the best opportunity to see the spectacular views of the wilderness on the way there. Upgrade to the private open-sided jeep option for more comfort and to go deeper into the bush.
                                    <br><br>
                                    Your professional and experienced guide will pick you up from your hotel early in the morning and give you an informative overview of the game drive.
                                    <br><br>
                                    Once you arrive at Nairobi National Park, you'll start your 4-hour game drive in the same open-roofed van, perfect for getting a 360-degree view of the scenery.
                                    <br><br>
                                    Keep your eyes peeled in search of lion, leopard, buffalo, rhino, jackal, and many other animals. You should easily spot the monkeys near the gate - have your camera ready to catch these playful creatures. Standing, you'll be able to spot animals from afar in their natural habitats.
                                    <br><br>
                                    After a half-day on this exciting safari adventure, your driver will drop you off at your hotel.
                                    <br>

                                </div>
                            </div>

                        </div>
                    </div>

                </div>

            <!-- Home packages section html start -->
            <section class="package-section">
                <div class="container">
                   <div class="section-heading text-center">
                      <div class="row">
                         <div class="col-lg-8 offset-lg-2">
                            <h2>Nairobi National Park Game Drives Packages</h2>
                         </div>
                      </div>
                   </div>
                   <div class="package-inner">
                      <div class="row">
                         <div class="col-lg-4 col-md-6">
                            <div class="package-wrap">
                               <figure class="feature-image">
                                  <a href="#">
                                     <img src="{{ asset('assets/images/nairobi/1_pack.jpg') }}" alt="">
                                  </a>
                               </figure>
                               <div class="package-price">
                                  <h6>
                                     <span>$1,900 </span> / per person
                                  </h6>
                               </div>
                               <div class="package-content-wrap">
                                  <div class="package-meta text-center">
                                     <ul>
                                        <li>
                                           <i class="far fa-clock"></i>
                                           7D/6N
                                        </li>
                                        <li>
                                           <i class="fas fa-user-friends"></i>
                                           People: 5
                                        </li>
                                        <li>
                                           <i class="fas fa-map-marker-alt"></i>
                                           Kenya
                                        </li>
                                     </ul>
                                  </div>
                                  <div class="package-content">
                                     <h3>
                                        <a href="#">Safari Tour; Nairobi National Park</a>
                                     </h3>
                                     <div class="review-area">
                                        <span class="review-text">(25 reviews)</span>
                                        <div class="rating-start" title="Rated 5 out of 5">
                                           <span style="width: 60%"></span>
                                        </div>
                                     </div>
                                     <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit luctus nec ullam. Ut elit tellus, luctus nec ullam elit tellpus.</p>
                                     <div class="btn-wrap">
                                        <a href="#" class="button-text">Book Now<i class="fas fa-arrow-right"></i></a>
                                     </div>
                                  </div>
                               </div>
                            </div>
                         </div>
                         <div class="col-lg-4 col-md-6">
                            <div class="package-wrap">
                               <figure class="feature-image">
                                  <a href="#">
                                     <img src="{{ asset('assets/images/nairobi/2_pack.jpg') }}" alt="">
                                  </a>
                               </figure>
                               <div class="package-price">
                                  <h6>
                                     <span>$1,230 </span> / per person
                                  </h6>
                               </div>
                               <div class="package-content-wrap">
                                  <div class="package-meta text-center">
                                     <ul>
                                        <li>
                                           <i class="far fa-clock"></i>
                                           5D/4N
                                        </li>
                                        <li>
                                           <i class="fas fa-user-friends"></i>
                                           People: 8
                                        </li>
                                        <li>
                                           <i class="fas fa-map-marker-alt"></i>
                                           Canada
                                        </li>
                                     </ul>
                                  </div>
                                  <div class="package-content">
                                     <h3>
                                        <a href="#">Giraffe Center,elephant orphanage and Nairobi National Park</a>
                                     </h3>
                                     <div class="review-area">
                                        <span class="review-text">(17 reviews)</span>
                                        <div class="rating-start" title="Rated 5 out of 5">
                                           <span style="width: 100%"></span>
                                        </div>
                                     </div>
                                     <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit luctus nec ullam. Ut elit tellus, luctus nec ullam elit tellpus.</p>
                                     <div class="btn-wrap">
                                        <a href="#" class="button-text">Book Now<i class="fas fa-arrow-right"></i></a>
                                     </div>
                                  </div>
                               </div>
                            </div>
                         </div>
                         <div class="col-lg-4 col-md-6">
                            <div class="package-wrap">
                               <figure class="feature-image">
                                  <a href="#">
                                     <img src="{{ asset('assets/images/nairobi/3_pack.jpg') }}" alt="">
                                  </a>
                               </figure>
                               <div class="package-price">
                                  <h6>
                                     <span>$2,000 </span> / per person
                                  </h6>
                               </div>
                               <div class="package-content-wrap">
                                  <div class="package-meta text-center">
                                     <ul>
                                        <li>
                                           <i class="far fa-clock"></i>
                                           6D/5N
                                        </li>
                                        <li>
                                           <i class="fas fa-user-friends"></i>
                                           People: 6
                                        </li>
                                        <li>
                                           <i class="fas fa-map-marker-alt"></i>
                                           Portugal
                                        </li>
                                     </ul>
                                  </div>
                                  <div class="package-content">
                                     <h3>
                                        <a href="#">Early morning Nairobi national park Elephant orphanage and Giraffe center tour</a>
                                     </h3>
                                     <div class="review-area">
                                        <span class="review-text">(22 reviews)</span>
                                        <div class="rating-start" title="Rated 5 out of 5">
                                           <span style="width: 80%"></span>
                                        </div>
                                     </div>
                                     <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit luctus nec ullam. Ut elit tellus, luctus nec ullam elit tellpus.</p>
                                     <div class="btn-wrap">
                                        <a href="#" class="button-text">Book Now<i class="fas fa-arrow-right"></i></a>
                                     </div>
                                  </div>
                               </div>
                            </div>
                         </div>
                      </div>
                   </div>
                </div>
             </section>
             <!-- packages html end -->

            </div>

        </div>
    </div>
</div>
@endsection
